/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunk_serializer.common;

import com.ishland.c2me.rewrites.chunk_serializer.common.NbtWriterVisitor;
import com.ishland.c2me.rewrites.chunk_serializer.common.utils.StringBytesConvertible;
import com.ishland.c2me.rewrites.chunk_serializer.common.utils.UnsafeUtils;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.UTFDataFormatException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.stream.LongStream;
import net.minecraft.class_2378;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5627;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class NbtWriter {
    private static final int INCREMENT = 2;
    private static final Unsafe UNSAFE = UnsafeUtils.UNSAFE;
    private static final int BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private static final int INT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
    private static final int LONG_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
    private long size = 65536L;
    private long buffer = UNSAFE.allocateMemory(this.size);
    private long remaining = this.size;
    private long pointer = this.buffer;
    private NbtWriterVisitor visitor;

    private void claimCapacity(long extra) {
        this.remaining -= extra;
        while (this.remaining < 0L) {
            this.remaining += this.size * 1L;
            this.size *= 2L;
            long offset = this.getOffset();
            this.buffer = UNSAFE.reallocateMemory(this.buffer, this.size);
            this.pointer = this.buffer + offset;
        }
    }

    public long getOffset() {
        return this.pointer - this.buffer;
    }

    public void start(byte type) {
        this.putByteEntry(type);
        if (type != 0) {
            this.putShortEntry((short)0);
        }
    }

    private void insertByte(byte value) {
        UNSAFE.putByte(this.pointer, value);
        ++this.pointer;
    }

    private void insertShort(short value) {
        UNSAFE.putShort(this.pointer, Short.reverseBytes(value));
        this.pointer += 2L;
    }

    private void insertInt(int value) {
        UNSAFE.putInt(this.pointer, Integer.reverseBytes(value));
        this.pointer += 4L;
    }

    private void insertLong(long value) {
        UNSAFE.putLong(this.pointer, Long.reverseBytes(value));
        this.pointer += 8L;
    }

    private void insertFloat(float value) {
        this.insertInt(Float.floatToRawIntBits(value));
    }

    private void insertDouble(double value) {
        this.insertLong(Double.doubleToRawLongBits(value));
    }

    private void insertByteArray(byte[] value) {
        UNSAFE.copyMemory(value, BYTE_ARRAY_OFFSET, null, this.pointer, value.length);
        this.pointer += (long)value.length;
    }

    private void insertIntArray(int[] value) {
        for (int i : value) {
            UNSAFE.putInt(this.pointer, Integer.reverseBytes(i));
            this.pointer += 4L;
        }
    }

    private void insertLongArray(long[] value) {
        for (long i : value) {
            UNSAFE.putLong(this.pointer, Long.reverseBytes(i));
            this.pointer += 8L;
        }
    }

    private void insertLongArray(LongIterable value) {
        LongIterator iter = value.longIterator();
        while (iter.hasNext()) {
            UNSAFE.putLong(this.pointer, Long.reverseBytes(iter.nextLong()));
            this.pointer += 8L;
        }
    }

    public void putBooleanEntry(boolean value) {
        this.putByteEntry(value ? (byte)1 : 0);
    }

    public void putByteEntry(byte value) {
        this.claimCapacity(1L);
        this.insertByte(value);
    }

    public void putShortEntry(short value) {
        this.claimCapacity(2L);
        this.insertShort(value);
    }

    public void putIntEntry(int value) {
        this.claimCapacity(4L);
        this.insertInt(value);
    }

    public void putLongEntry(long value) {
        this.claimCapacity(8L);
        this.insertLong(value);
    }

    public void putFloatEntry(float value) {
        this.claimCapacity(4L);
        this.insertFloat(value);
    }

    public void putDoubleEntry(double value) {
        this.claimCapacity(8L);
        this.insertDouble(value);
    }

    public void putByteArrayEntry(byte[] value) {
        this.claimCapacity(4L + (long)value.length);
        this.insertInt(value.length);
        this.insertByteArray(value);
    }

    public void putIntArrayEntry(int[] value) {
        this.claimCapacity(4L + (long)value.length * 4L);
        this.putIntEntry(value.length);
        this.insertIntArray(value);
    }

    public void putLongArrayEntry(long[] value) {
        this.claimCapacity(4L + (long)value.length * 8L);
        this.putIntEntry(value.length);
        this.insertLongArray(value);
    }

    public void putStringEntry(byte[] s) {
        this.claimCapacity(s.length);
        this.insertByteArray(s);
    }

    public void putStringEntry(String s) {
        this.putStringEntry(NbtWriter.getStringBytes(s));
    }

    public <T> void putRegistryEntry(class_2378<T> registry, T value) {
        this.putStringEntry(NbtWriter.getNameBytesFromRegistry(registry, value));
    }

    public <T> void putRegistryEntry(class_6880<T> registryEntry) {
        this.putStringEntry(NbtWriter.getNameBytesFromRegistry(registryEntry));
    }

    public void compoundEntryStart() {
    }

    @Deprecated
    public void putElementEntry(class_2520 data) {
        data.method_32289((class_5627)this.getVisitor());
    }

    @Deprecated
    public void putElementList(String name, List<? extends class_2520> element) {
        if (element.isEmpty()) {
            this.startFixedList(NbtWriter.getStringBytes(name), element.size(), (byte)0);
        } else {
            this.startFixedList(NbtWriter.getStringBytes(name), element.size(), element.get(0).method_10711());
        }
        for (class_2520 class_25202 : element) {
            class_25202.method_32289((class_5627)this.getVisitor());
        }
    }

    public void startFixedListEntry(int size, byte heldType) {
        this.claimCapacity(5L);
        this.insertByte(heldType);
        this.insertInt(size);
    }

    public void putBoolean(byte[] name, boolean value) {
        this.putByte(name, value ? (byte)1 : 0);
    }

    public void putByte(byte[] name, byte value) {
        this.claimCapacity(1L + (long)name.length + 1L);
        this.insertByte((byte)1);
        this.insertByteArray(name);
        this.insertByte(value);
    }

    public void putShort(byte[] name, short value) {
        this.claimCapacity(1L + (long)name.length + 2L);
        this.insertByte((byte)2);
        this.insertByteArray(name);
        this.insertShort(value);
    }

    public void putInt(byte[] name, int value) {
        this.claimCapacity(1L + (long)name.length + 4L);
        this.insertByte((byte)3);
        this.insertByteArray(name);
        this.insertInt(value);
    }

    public void putLong(byte[] name, long value) {
        this.claimCapacity(1L + (long)name.length + 8L);
        this.insertByte((byte)4);
        this.insertByteArray(name);
        this.insertLong(value);
    }

    public void putFloat(byte[] name, float value) {
        this.claimCapacity(1L + (long)name.length + 4L);
        this.insertByte((byte)5);
        this.insertByteArray(name);
        this.insertFloat(value);
    }

    public void putDouble(byte[] name, double value) {
        this.claimCapacity(1L + (long)name.length + 8L);
        this.insertByte((byte)6);
        this.insertByteArray(name);
        this.insertDouble(value);
    }

    @Deprecated
    public void putString(byte[] name, String value) {
        this.putString(name, NbtWriter.getStringBytes(value));
    }

    public void putString(byte[] name, byte[] value) {
        this.claimCapacity(1L + (long)name.length + (long)value.length);
        this.insertByte((byte)8);
        this.insertByteArray(name);
        this.insertByteArray(value);
    }

    public NbtWriter startCompound(byte[] name) {
        this.claimCapacity(1L + (long)name.length);
        this.insertByte((byte)10);
        this.insertByteArray(name);
        return this;
    }

    public void finishCompound() {
        this.claimCapacity(1L);
        this.insertByte((byte)0);
    }

    public void putDoubles(byte[] name, double[] value) {
        this.startFixedList(name, value.length, (byte)6);
        for (double d : value) {
            this.putDoubleEntry(d);
        }
    }

    public <T> void putRegistry(byte[] name, class_2378<T> registry, T value) {
        this.putString(name, NbtWriter.getNameBytesFromRegistry(registry, value));
    }

    public long startList(byte[] name, byte type) {
        this.claimCapacity(1L + (long)name.length + 1L + 4L);
        this.insertByte((byte)9);
        this.insertByteArray(name);
        this.insertByte(type);
        long offset = this.getOffset();
        this.pointer += 4L;
        return offset;
    }

    public void finishList(long indicesStart, int indicesCount) {
        UNSAFE.putInt(this.buffer + indicesStart, Integer.reverseBytes(indicesCount));
    }

    public void startFixedList(byte[] name, int size, byte type) {
        this.claimCapacity(1L + (long)name.length + 1L + 4L);
        this.insertByte((byte)9);
        this.insertByteArray(name);
        this.insertByte(type);
        this.insertInt(size);
    }

    public void putByteArray(byte[] name, byte[] value) {
        this.claimCapacity(1L + (long)name.length + 4L + (long)value.length);
        this.insertByte((byte)7);
        this.insertByteArray(name);
        this.insertInt(value.length);
        this.insertByteArray(value);
    }

    public void putIntArray(byte[] name, int[] value) {
        this.claimCapacity(1L + (long)name.length + 4L + (long)value.length * 4L);
        this.insertByte((byte)11);
        this.insertByteArray(name);
        this.insertInt(value.length);
        this.insertIntArray(value);
    }

    public void putLongArray(byte[] name, long[] value) {
        this.claimCapacity(1L + (long)name.length + 4L + (long)value.length * 8L);
        this.insertByte((byte)12);
        this.insertByteArray(name);
        this.insertInt(value.length);
        this.insertLongArray(value);
    }

    public void putLongArray(byte[] name, LongCollection value) {
        this.claimCapacity(1L + (long)name.length + 4L + (long)value.size() * 8L);
        this.insertByte((byte)12);
        this.insertByteArray(name);
        this.insertInt(value.size());
        this.insertLongArray((LongIterable)value);
    }

    public void putLongArray(byte[] name, LongStream value) {
        this.claimCapacity(1L + (long)name.length + 4L);
        this.insertByte((byte)12);
        this.insertByteArray(name);
        long offset = this.getOffset();
        this.insertInt(-1);
        int count = 0;
        PrimitiveIterator.OfLong iter = value.iterator();
        while (iter.hasNext()) {
            this.claimCapacity(8L);
            UNSAFE.putLong(this.pointer, Long.reverseBytes(iter.nextLong()));
            this.pointer += 8L;
            ++count;
        }
        UNSAFE.putInt(this.buffer + offset, Integer.reverseBytes(count));
    }

    @Deprecated
    public void putElement(String name, class_2520 data) {
        this.getVisitor().visit(name, data);
    }

    @Deprecated
    public void putElement(byte[] name, class_2520 data) {
        this.getVisitor().visit(name, data);
    }

    public static byte @NotNull [] getAsciiStringBytes(String string) {
        byte[] bytes;
        for (byte aByte : bytes = string.getBytes(StandardCharsets.UTF_8)) {
            if (aByte > 0) continue;
            throw new IllegalArgumentException("String contains invalid characters");
        }
        return NbtWriter.wrapAsciiBytes(bytes);
    }

    @NotNull
    private static byte[] wrapAsciiBytes(byte[] bytes) {
        byte[] wrappedBytes = new byte[bytes.length + 2];
        wrappedBytes[0] = (byte)(bytes.length >> 8);
        wrappedBytes[1] = (byte)bytes.length;
        System.arraycopy(bytes, 0, wrappedBytes, 2, bytes.length);
        return wrappedBytes;
    }

    public static byte @NotNull [] getStringBytes(String string) {
        byte[] res = new byte[string.length() * 3 + 2];
        int index = 2;
        for (char c : string.toCharArray()) {
            if (c >= '\u0001' && c <= '\u007f') {
                res[index++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                res[index++] = (byte)(0xC0 | 0x1F & c >> 6);
                res[index++] = (byte)(0x80 | 0x3F & c);
                continue;
            }
            res[index++] = (byte)(0xE0 | 0xF & c >> 12);
            res[index++] = (byte)(0x80 | 0x3F & c >> 6);
            res[index++] = (byte)(0x80 | 0x3F & c);
        }
        int length = index - 2;
        if (length > 65535) {
            throw new RuntimeException(new UTFDataFormatException("String too large"));
        }
        res[0] = (byte)(length >> 8);
        res[1] = (byte)length;
        return Arrays.copyOf(res, index);
    }

    public static <T> byte @NotNull [] getNameBytesFromRegistry(class_2378<T> registry, T value) {
        return NbtWriter.getNameBytesFromId(registry.method_10221(value));
    }

    public static <T> byte @NotNull [] getNameBytesFromRegistry(class_6880<T> value) {
        return NbtWriter.getNameBytesFromId(((class_5321)value.method_40230().get()).method_29177());
    }

    public static <T> byte @NotNull [] getNameBytesFromId(class_2960 id) {
        if (id instanceof StringBytesConvertible) {
            StringBytesConvertible stringBytesConvertible = (StringBytesConvertible)id;
            return stringBytesConvertible.getStringBytes();
        }
        return NbtWriter.getAsciiStringBytes(id.toString());
    }

    public NbtWriterVisitor getVisitor() {
        if (this.visitor == null) {
            this.visitor = new NbtWriterVisitor(this);
        }
        return this.visitor;
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[(int)this.getOffset()];
        UNSAFE.copyMemory(null, this.buffer, bytes, BYTE_ARRAY_OFFSET, bytes.length);
        return bytes;
    }

    public void release() {
        if (this.buffer != 0L) {
            UNSAFE.freeMemory(this.buffer);
            this.buffer = 0L;
        }
    }
}

